<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Normal_Quiz_Question extends Model
{
    use HasFactory;

    protected $table = 'tbl_normal_quiz_question';
    protected $guarded = array();

    protected $casts = [
        'id' => 'integer',
        'category_id' => 'integer',
        'skill_id' => 'integer',
        'classification_id' => 'integer',
        'level_id' => 'integer',
        'image' => 'string',
        'question' => 'string',
        'option_a' => 'string',
        'option_b' => 'string',
        'option_c' => 'string',
        'option_d' => 'string',
        'correct_answer' => 'integer',
        'note' => 'string',
        'status' => 'integer',
    ];

    public function category()
    {
        return $this->belongsTo(Category::class, 'category_id');
    }
    public function skill()
    {
        return $this->belongsTo(Skill::class, 'skill_id');
    }
    public function classification()
    {
        return $this->belongsTo(Classification::class, 'classification_id');
    }
    public function level()
    {
        return $this->belongsTo(Level::class, 'level_id');
    }
}
